<?php
session_start();
require_once 'db.php';

// Cek login (LOGIKA PHP TIDAK BERUBAH)
if (!isset($_SESSION['is_siswa_logged_in']) || $_SESSION['is_siswa_logged_in'] !== true) {
    header("Location: login_siswa.php");
    exit;
}

$siswa_id = $_SESSION['siswa_id'];

// Ambil data siswa
$stmt = $pdo->prepare("SELECT s.*, k.nama_kelas FROM siswa s JOIN kelas k ON s.kelas_id = k.id WHERE s.siswa_id = ?");
$stmt->execute([$siswa_id]);
$siswa = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$siswa) {
    session_destroy();
    header("Location: login_siswa.php");
    exit;
}

// Generate QR Code jika NISN ada
$qr_code_path = null;
if (!empty($siswa['nisn'])) {
    if (file_exists('phpqrcode/qrlib.php')) {
        require_once 'phpqrcode/qrlib.php';
        
        if (!file_exists('temp_qr')) {
            @mkdir('temp_qr', 0777, true);
        }
        
        $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
        $base_url = $protocol . "://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
        
        $qr_data = $base_url . "/qr_process.php?nisn=" . $siswa['nisn'];
        $qr_code_path = 'temp_qr/kartu_ktp_' . $siswa_id . '.png';
        
        if (class_exists('QRcode')) {
            QRcode::png($qr_data, $qr_code_path, QR_ECLEVEL_L, 4); 
        } else {
            $qr_code_path = null; 
        }
    }
}

// Format data
$tanggal_lahir_formatted = '';
if (!empty($siswa['tanggal_lahir'])) {
    $tanggal_lahir_formatted = date('d/m/Y', strtotime($siswa['tanggal_lahir']));
}

// Persiapan URL Gambar melalui Proxy (untuk mengatasi CORS)
$proxied_image_url = '';
if (!empty($siswa['foto_path'])) {
    // Encoding URL agar aman dilewatkan sebagai parameter GET
    $proxied_image_url = 'image_proxy.php?url=' . urlencode($siswa['foto_path']);
}

$jk_long = $siswa['jenis_kelamin'] == 'L' ? 'LAKI-LAKI' : ($siswa['jenis_kelamin'] == 'P' ? 'PEREMPUAN' : '-');
$current_year = date('Y');
$masa_berlaku = date('Y', strtotime('+1 year')); 
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kartu Pelajar - <?= htmlspecialchars($siswa['nama']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    
    <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>

    <script>
        /**
         * Fungsi untuk menghasilkan Barcode Batang menggunakan JsBarcode
         */
        function generateBarcode() {
            const nisnOrId = "<?= htmlspecialchars($siswa['nisn'] ?? $siswa_id) ?>";
            const barcodeElement = document.getElementById('barcode');
            
            if (barcodeElement && nisnOrId) {
                JsBarcode(barcodeElement, nisnOrId, {
                    format: "CODE128", 
                    displayValue: true,
                    text: nisnOrId,
                    fontSize: 7, 
                    margin: 0, 
                    height: 30, 
                    width: 1.2, 
                    lineColor: "#111827" 
                });
            }
        }
        
        // Opsi html2canvas yang digunakan oleh kedua fungsi
        const html2canvasOptions = {
            scale: 3, 
            useCORS: true, 
            allowTaint: true 
        };

        // Mengambil container tombol agar dapat dinonaktifkan
        const noPrintControls = document.querySelector('.no-print');
        
        /**
         * 💾 Menyimpan hanya sisi DEPAN kartu sebagai file PNG
         */
        function saveFrontCardAsImage() {
            const card = document.querySelector('#singleCardContainer .digital-card'); 
            
            noPrintControls.style.pointerEvents = 'none';

            html2canvas(card, html2canvasOptions).then(canvas => {
                const image = canvas.toDataURL('image/png'); 
                const link = document.createElement('a');
                link.download = 'Kartu_Pelajar_Depan_<?= htmlspecialchars($siswa['nisn'] ?? $siswa_id) ?>.png';
                link.href = image;
                
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);

                noPrintControls.style.pointerEvents = 'auto';
            }).catch(error => {
                console.error('Gagal menyimpan gambar depan:', error);
                alert('Gagal menyimpan kartu depan sebagai gambar. Pastikan skrip image_proxy.php sudah berfungsi.');
                noPrintControls.style.pointerEvents = 'auto';
            });
        }
        
        /**
         * 💾 Menyimpan DUA SISI kartu sebagai file PNG
         */
        function saveDualCardAsImage() {
            const cardContainer = document.getElementById('dualCardContainerCards');
            
            noPrintControls.style.pointerEvents = 'none';

            html2canvas(cardContainer, html2canvasOptions).then(canvas => {
                const image = canvas.toDataURL('image/png'); 
                const link = document.createElement('a');
                link.download = 'Kartu_Pelajar_DualSisi_<?= htmlspecialchars($siswa['nisn'] ?? $siswa_id) ?>.png';
                link.href = image;
                
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);

                noPrintControls.style.pointerEvents = 'auto';
            }).catch(error => {
                console.error('Gagal menyimpan gambar dual sisi:', error);
                alert('Gagal menyimpan kartu dual sisi sebagai gambar. Pastikan skrip image_proxy.php sudah berfungsi.');
                noPrintControls.style.pointerEvents = 'auto';
            });
        }
        
        // Panggil fungsi Barcode setelah semua elemen dimuat
        window.onload = function() {
            generateBarcode();
        };
    </script>
    
    <style>
        /* --- Gaya Cetak (Print Styles) --- */
        @media print {
            body * { visibility: hidden; }
            #dualCardContainerCards, #dualCardContainerCards * { visibility: visible !important; }
            #dualCardContainerCards {
                position: absolute;
                left: 0;
                top: 0;
                display: flex !important;
                flex-wrap: nowrap;
                justify-content: flex-start;
                align-items: flex-start;
                width: 210mm; 
                margin: 0;
            }
            .digital-card {
                position: static !important; 
                width: 100mm;
                height: 60mm;
                border: 1px solid #000; 
                margin: 5mm; 
                box-shadow: none !important;
            }
            .no-print, #singleCardContainer {
                display: none !important;
            }
            @page {
                size: A4 landscape; 
                margin: 0;
            }
        }
        
        /* --- Gaya Kartu (Screen & Print) --- */
        .digital-card {
            width: 100mm;
            height: 60mm;
            background: #ffffff; 
            border: 1px solid #d1d5db; 
            border-radius: 12px; 
            box-shadow: 0 10px 30px rgba(0,0,0,0.1); 
            position: relative;
            overflow: hidden;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
            color: #1f2937;
        }

        .header-bg {
            background-color: #111827;
            color: white;
        }

        .accent-color {
            color: #3b82f6;
        }
        
        /* Ukuran Font Disesuaikan */
        .text-custom-xxs { font-size: 7px; line-height: 1; }
        .text-custom-xs { font-size: 8px; line-height: 1.1; }
        .text-custom-sm { font-size: 9px; line-height: 1.2; }
        .text-custom-md { font-size: 10px; line-height: 1.3; }
        
        .data-label {
            color: #6b7280; 
            font-weight: 500;
        }

        .data-value {
            color: #111827; 
            font-weight: 700;
        }
        
        /* FOTO PROPORSIONAL */
        .card-photo {
            width: 23mm; 
            height: 31mm; 
            border: 3px solid #3b82f6;
            background: #f3f4f6;
            border-radius: 4px;
            overflow: hidden;
        }
        
        .card-qr {
            width: 22mm; 
            height: 22mm;
            background: white;
            padding: 3px;
            border: 2px solid #3b82f6;
            border-radius: 6px;
        }
        
        .digital-card-back .relative-content {
            position: relative; 
            height: 50mm; 
        }
        
        .barcode-corner {
            position: absolute;
            bottom: 5px; 
            right: 5px; 
            width: 35mm; 
            text-align: center;
            background: white;
            padding: 2px;
            border: 1px solid #d1d5db;
            border-radius: 4px;
        }

        #barcode {
            width: 100%; 
            height: 12mm; 
            display: block; 
        }

        .barcode-corner .data-label {
             font-size: 6px; 
             margin-bottom: 0;
             line-height: 1;
        }
        
        /* --- Gaya Tombol Modern --- */
        .app-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.75rem 1.25rem; /* px-5 py-3 */
            border-radius: 0.625rem; /* rounded-xl */
            font-weight: 600; /* font-semibold */
            text-align: center;
            transition: all 0.2s ease-in-out;
            text-shadow: 0 1px 1px rgba(0, 0, 0, 0.05); /* Sedikit efek 3D */
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.06); /* Shadow default */
            border: none;
            cursor: pointer;
        }

        .app-button:hover {
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.1); /* Shadow lebih dalam */
            transform: translateY(-1px); /* Efek sedikit terangkat */
        }
        
        .app-button:active {
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.06);
            transform: translateY(0); /* Efek ditekan */
        }

        .btn-primary {
            background-color: #2563eb; /* blue-600 */
            color: white;
        }
        .btn-primary:hover {
            background-color: #1d4ed8; /* blue-700 */
        }

        .btn-success {
            background-color: #10b981; /* green-500 */
            color: white;
        }
        .btn-success:hover {
            background-color: #059669; /* green-600 */
        }

        .btn-warning {
            background-color: #ef4444; /* red-500 */
            color: white;
        }
        .btn-warning:hover {
            background-color: #dc2626; /* red-600 */
        }
        
        .btn-danger {
            background-color: #991b1b; /* red-800 */
            color: white;
        }
        .btn-danger:hover {
            background-color: #7f1d1d; /* red-900 */
        }

        .btn-secondary {
            background-color: #8b5cf6; /* purple-500 */
            color: white;
        }
        .btn-secondary:hover {
            background-color: #7c3aed; /* purple-600 */
        }
    </style>
</head>
<body class="bg-gray-100 min-h-screen p-4 flex flex-col items-center">
    
    <div class="no-print mb-8 flex flex-wrap gap-3 justify-center">
        <a href="dashboard_siswa.php" class="app-button btn-primary text-sm">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M11 15l-3-3m0 0l3-3m-3 3h8M3 12a9 9 0 1118 0 9 9 0 01-18 0z" />
            </svg>
            Kembali
        </a>
        
        <button onclick="window.print()" class="app-button btn-success text-sm">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m4 0v3a1 1 0 001 1h2a1 1 0 001-1v-3m2 0H9" />
            </svg>
            Cetak Dual Sisi
        </button>
        
        <button onclick="saveFrontCardAsImage()" class="app-button btn-warning text-sm">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
            </svg>
            Download Depan Saja
        </button>
        
        <button onclick="saveDualCardAsImage()" class="app-button btn-danger text-sm">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
            </svg>
            Download Depan & Belakang
        </button>
        
        <a href="kartu_pelajar_besar.php" class="app-button btn-secondary text-sm">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
            </svg>
            Versi Besar
        </a>
    </div>

    <div id="singleCardContainer" class="mb-10 p-4 bg-white rounded-xl shadow-2xl">
        <h3 class="text-lg font-extrabold text-gray-800 mb-4 border-b pb-2">Kartu Depan Tunggal (Pratinjau)</h3>
        
        <div class="digital-card">
            
            <div class="header-bg text-center py-1">
                <div class="text-custom-sm font-bold tracking-wide">DIGITAL ID CARD PELAJAR</div>
                <div class="text-custom-xs font-light opacity-80">SDM03 KREATIF | Tahun Ajaran <?= $current_year ?>/<?= $current_year + 1 ?></div>
            </div>

            <div class="flex h-[50mm]">
                
                <div class="w-[65%] p-3 pt-2 flex flex-col justify-start">
                    
                    <div class="mb-2">
                        <span class="data-label text-custom-xs block">NISN / ID SISWA</span>
                        <span class="data-value block font-extrabold tracking-widest text-2xl accent-color leading-none"><?= htmlspecialchars($siswa['nisn'] ?? 'NISN BELUM DIISI') ?></span>
                    </div>
                    
                    <div class="space-y-1 text-custom-md">
                        <div class="flex">
                            <span class="data-label w-[40%]">Nama Lengkap</span>
                            <span class="data-value w-[60%] font-extrabold">: <?= htmlspecialchars($siswa['nama']) ?></span>
                        </div>
                        
                        <div class="flex">
                            <span class="data-label w-[40%]">Kelas / Rombel</span>
                            <span class="data-value w-[60%]">: <?= htmlspecialchars($siswa['nama_kelas']) ?></span>
                        </div>
                        
                        <div class="flex">
                            <span class="data-label w-[40%]">Jenis Kelamin</span>
                            <span class="data-value w-[60%]">: <?= $jk_long ?></span>
                        </div>
                        <div class="flex">
                            <span class="data-label w-[40%]">Tempat, Tgl Lahir</span>
                            <span class="data-value w-[60%]">: <?= htmlspecialchars($siswa['tempat_lahir'] ?? '-') ?>, <?= $tanggal_lahir_formatted ?: '-' ?></span>
                        </div>
                    </div>

                    <div class="mt-auto pt-2 text-custom-xs border-t border-gray-200">
                        <div class="flex justify-between">
                            <span class="data-label font-bold text-gray-700">VALIDITAS DIGITAL</span>
                            <span class="font-bold text-green-600">AKTIF</span>
                        </div>
                        <div class="text-custom-xxs text-gray-500 mt-0.5">
                            Kartu ini berlaku sebagai tanda pengenal resmi yang dikeluarkan oleh sistem SDM03.
                        </div>
                    </div>

                </div>
                
                <div class="w-[35%] bg-gray-50 flex flex-col items-center p-2 pt-1 border-l border-gray-200">
                    
                    <div class="card-photo flex items-center justify-center mb-2">
                        <?php if (!empty($proxied_image_url)): ?>
                            <img src="<?= htmlspecialchars($proxied_image_url) ?>" 
                                    alt="Foto Siswa" 
                                    class="w-full h-full object-cover">
                        <?php else: ?>
                            <div class="text-gray-500 text-xs text-center">FOTO<br>BELUM ADA</div>
                        <?php endif; ?>
                    </div>

                    <div class="text-center mt-auto">
                        <?php if ($qr_code_path && file_exists($qr_code_path)): ?>
                        <div class="card-qr mx-auto shadow-lg">
                            <img src="<?= $qr_code_path ?>" alt="QR Code" class="w-full h-full">
                        </div>
                        <div class="text-custom-xs font-bold text-gray-800 mt-1">SCAN UNTUK OTENTIKASI</div>
                        <?php else: ?>
                        <div class="text-custom-xxs text-center text-red-500 font-bold">QR NON-AKTIF</div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
            
        </div>
    </div>
    
    <div class="w-full max-w-5xl p-4 bg-white rounded-xl shadow-2xl">
        <h3 class="text-lg font-extrabold text-gray-800 mb-4 border-b pb-2 text-center">Kartu Depan & Belakang (Untuk Cetak/Simpan)</h3>
        
        <div id="dualCardContainerCards" class="flex gap-8 justify-center flex-wrap">

            <div class="digital-card">
                
                <div class="header-bg text-center py-1">
                    <div class="text-custom-sm font-bold tracking-wide">DIGITAL ID CARD PELAJAR</div>
                    <div class="text-custom-xs font-light opacity-80">SDM03 KREATIF | Tahun Ajaran <?= $current_year ?>/<?= $current_year + 1 ?></div>
                </div>

                <div class="flex h-[50mm]">
                    
                    <div class="w-[65%] p-3 pt-2 flex flex-col justify-start">
                        
                        <div class="mb-2">
                            <span class="data-label text-custom-xs block">NISN / ID SISWA</span>
                            <span class="data-value block font-extrabold tracking-widest text-2xl accent-color leading-none"><?= htmlspecialchars($siswa['nisn'] ?? 'NISN BELUM DIISI') ?></span>
                        </div>
                        
                        <div class="space-y-1 text-custom-md">
                            <div class="flex">
                                <span class="data-label w-[40%]">Nama Lengkap</span>
                                <span class="data-value w-[60%] font-extrabold">: <?= htmlspecialchars($siswa['nama']) ?></span>
                            </div>
                            
                            <div class="flex">
                                <span class="data-label w-[40%]">Kelas / Rombel</span>
                                <span class="data-value w-[60%]">: <?= htmlspecialchars($siswa['nama_kelas']) ?></span>
                            </div>
                            
                            <div class="flex">
                                <span class="data-label w-[40%]">Jenis Kelamin</span>
                                <span class="data-value w-[60%]">: <?= $jk_long ?></span>
                            </div>
                            <div class="flex">
                                <span class="data-label w-[40%]">Tempat, Tgl Lahir</span>
                                <span class="data-value w-[60%]">: <?= htmlspecialchars($siswa['tempat_lahir'] ?? '-') ?>, <?= $tanggal_lahir_formatted ?: '-' ?></span>
                            </div>
                        </div>

                        <div class="mt-auto pt-2 text-custom-xs border-t border-gray-200">
                            <div class="flex justify-between">
                                <span class="data-label font-bold text-gray-700">VALIDITAS DIGITAL</span>
                                <span class="font-bold text-green-600">AKTIF</span>
                            </div>
                            <div class="text-custom-xxs text-gray-500 mt-0.5">
                                Kartu ini berlaku sebagai tanda pengenal resmi yang dikeluarkan oleh sistem SDM03.
                            </div>
                        </div>

                    </div>
                    
                    <div class="w-[35%] bg-gray-50 flex flex-col items-center p-2 pt-1 border-l border-gray-200">
                        
                        <div class="card-photo flex items-center justify-center mb-2">
                            <?php if (!empty($proxied_image_url)): ?>
                                <img src="<?= htmlspecialchars($proxied_image_url) ?>" 
                                        alt="Foto Siswa" 
                                        class="w-full h-full object-cover">
                            <?php else: ?>
                                <div class="text-gray-500 text-xs text-center">FOTO<br>BELUM ADA</div>
                            <?php endif; ?>
                        </div>

                        <div class="text-center mt-auto">
                            <?php if ($qr_code_path && file_exists($qr_code_path)): ?>
                            <div class="card-qr mx-auto shadow-lg">
                                <img src="<?= $qr_code_path ?>" alt="QR Code" class="w-full h-full">
                            </div>
                            <div class="text-custom-xs font-bold text-gray-800 mt-1">SCAN UNTUK OTENTIKASI</div>
                            <?php else: ?>
                            <div class="text-custom-xxs text-center text-red-500 font-bold">QR NON-AKTIF</div>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
                
            </div>

            <div class="digital-card digital-card-back">
                
                <div class="header-bg text-center py-1">
                    <div class="text-custom-sm font-bold tracking-wide">PERATURAN & OTENTIKASI</div>
                    <div class="text-custom-xs font-light opacity-80">SDM03 KREATIF</div>
                </div>
                
                <div class="p-3 flex flex-col relative-content">
                    
                    <div class="flex-grow text-custom-xs pr-[40mm]">
                        <span class="data-label block font-bold mb-1 accent-color">KETENTUAN PENGGUNAAN:</span>
                        <ul class="list-disc list-inside space-y-0.5 ml-1 text-gray-700">
                            <li>Kartu ini wajib dibawa saat di lingkungan sekolah.</li>
                            <li>Dilarang merusak atau memindahtangankan kartu ini.</li>
                            <li>Gunakan Barcode untuk absensi digital dan peminjaman buku.</li>
                            <li>Kartu berlaku selama menjadi siswa SDM03.</li>
                            <li>Hubungi TU jika kartu hilang atau rusak.</li>
                        </ul>
                    </div>
                    
                    <div class="mt-auto pt-2 text-custom-xxs text-left border-t border-gray-200 w-[60%]">
                        Kartu ini adalah properti sekolah dan harus dijaga dengan baik.
                        <div class="font-bold text-gray-800 mt-1">Berlaku s/d Lulus</div>
                    </div>
                    
                    <div class="barcode-corner">
                        <span class="data-label block text-custom-xxs font-bold accent-color">ID SISTEM</span>
                        <svg id="barcode"></svg>
                        <?php if (empty($siswa['nisn'])): ?>
                            <div class="text-custom-xxs text-red-500 font-bold mt-1">BARCODE GAGAL</div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>

        </div> 
    </div>
    
    <hr class="no-print mt-8 max-w-md w-full">

    <div class="no-print mt-8 max-w-md bg-green-50 border border-green-200 rounded-lg p-4">
        <h3 class="font-bold text-green-800 mb-2 text-sm">✨ Pembaruan Gaya Tombol Aplikasi Modern</h3>
        <ul class="text-green-700 text-xs list-disc list-inside space-y-1">
            <li>Dibuat kelas CSS baru (`.app-button`, `.btn-primary`, dsb.) untuk menerapkan gaya yang konsisten, modern, dan responsif.</li>
            <li>Tombol kini memiliki **sudut membulat yang lebih besar (`rounded-xl`)**, **bayangan (`box-shadow`)**, dan **efek hover/active** (sedikit terangkat saat disentuh) untuk *user experience* yang lebih baik.</li>
            <li>Tombol **Download** dibagi menjadi dua dengan warna berbeda untuk membedakan opsi **Depan Saja** dan **Depan & Belakang**.</li>
            <li>Ditambahkan **ikon SVG** yang relevan pada setiap tombol untuk visualisasi yang lebih baik.</li>
        </ul>
        <p class="text-green-600 text-xs mt-2">
            **Catatan:** Pastikan Anda menggunakan **Tailwind CSS** (sudah di-link) untuk gaya ini.
        </p>
    </div>
</body>
</html>