<?php include 'header.php'; ?>

<div class="mb-6 text-sm">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">Daftar Sekolah</a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class&school_id=<?php echo $school['id']; ?>" class="text-blue-600 hover:text-blue-800">Kelas di <?php echo htmlspecialchars($school['name']); ?></a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="text-blue-600 hover:text-blue-800">Dashboard</a>
    <span class="text-gray-400 mx-2">/</span>
    <span class="text-gray-600 font-semibold">Konfigurasi Asesmen</span>
</div>

<div class="mb-6 border-b pb-4">
    <h2 class="text-2xl font-bold text-gray-800">Konfigurasi Asesmen untuk: <?php echo htmlspecialchars($class['name']); ?></h2>
    <p class="text-gray-600">KKM: <?php echo $class['kktp']; ?></p>
</div>

<?php 
$progress = [1 => '25%', 2 => '50%', 3 => '100%'];
$step_titles = [1 => 'Max Soal & Bab', 2 => 'Nama Bab', 3 => 'Deskripsi TP'];
?>
<div class="mb-8">
    <div class="flex justify-between mb-1">
        <?php foreach ($step_titles as $s => $title): ?>
            <span class="text-xs font-semibold <?php echo ($s <= $step) ? 'text-indigo-600' : 'text-gray-400'; ?>"><?php echo $title; ?></span>
        <?php endforeach; ?>
    </div>
    <div class="w-full bg-gray-200 rounded-full h-2.5">
        <div class="bg-indigo-600 h-2.5 rounded-full transition-all duration-500" style="width: <?php echo $progress[$step]; ?>"></div>
    </div>
</div>

<div class="max-w-4xl mx-auto p-6 bg-white rounded-xl shadow-lg border border-gray-100">

<?php if ($step == 1): ?>
    <h3 class="text-xl font-bold text-gray-800 mb-4">Langkah 1: Konfigurasi Dasar</h3>
    <form method="POST" action="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=2" class="space-y-6">
        <input type="hidden" name="action_type" value="save_step_1">
        <input type="hidden" name="class_id" value="<?php echo $class_id; ?>">

        <div class="p-4 bg-blue-50 rounded-xl border-l-4 border-blue-500">
            <label class="block text-lg font-bold text-blue-800 mb-3">Pilih Tipe Asesmen</label>
            <div class="flex gap-8">
                <label class="inline-flex items-center text-gray-700">
                    <input type="radio" name="assessment_type" value="STS" 
                        <?php echo (($_SESSION['assessment_config']['type'] ?? '') == 'STS' || !isset($_SESSION['assessment_config']['type'])) ? 'checked' : ''; ?>
                        class="form-radio text-indigo-600 h-5 w-5">
                    <span class="ml-3 font-medium">Sumatif Tengah Semester (STS)</span>
                </label>
                <label class="inline-flex items-center text-gray-700">
                    <input type="radio" name="assessment_type" value="SAS" 
                        <?php echo (($_SESSION['assessment_config']['type'] ?? '') == 'SAS') ? 'checked' : ''; ?>
                        class="form-radio text-pink-600 h-5 w-5">
                    <span class="ml-3 font-medium">Sumatif Akhir Semester (SAS)</span>
                </label>
            </div>
            <p class="text-xs text-gray-500 mt-2">Pilih jenis asesmen yang sedang dikonfigurasi.</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="space-y-4">
                <p class="text-lg font-semibold text-gray-700 border-b pb-2 mb-3">Total Maks Soal</p>
                <div>
                    <label for="pg_max" class="block text-sm font-medium text-gray-700">Pilihan Ganda (PG)</label>
                    <input type="number" id="pg_max" name="pg_max" min="0" required 
                        value="<?php echo $config['pg_max'] ?? ($assessment['pg_max'] ?? 20); ?>" 
                        class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                </div>
                <div>
                    <label for="isian_max" class="block text-sm font-medium text-gray-700">Isian Singkat</label>
                    <input type="number" id="isian_max" name="isian_max" min="0" required 
                        value="<?php echo $config['isian_max'] ?? ($assessment['isian_max'] ?? 5); ?>" 
                        class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                </div>
                <div>
                    <label for="essay_max" class="block text-sm font-medium text-gray-700">Uraian (Esai)</label>
                    <input type="number" id="essay_max" name="essay_max" min="0" required 
                        value="<?php echo $config['essay_max'] ?? ($assessment['essay_max'] ?? 5); ?>" 
                        class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                </div>
            </div>

            <div>
                <p class="text-lg font-semibold text-gray-700 border-b pb-2 mb-3">Struktur Pembelajaran</p>
                <div>
                    <label for="chapter_count" class="block text-sm font-medium text-gray-700">Jumlah Bab/Materi Pokok</label>
                    <input type="number" id="chapter_count" name="chapter_count" min="1" required 
                        value="<?php echo $config['chapter_count'] ?? ($assessment ? count(getAssessmentConfig($pdo, $assessment['id'])) : 4); ?>" 
                        class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                    <p class="text-xs text-gray-500 mt-1">Masukkan jumlah bab yang diujikan.</p>
                </div>
            </div>
        </div>
        <div class="flex justify-end">
            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-6 rounded-lg shadow-md transition">Lanjut ke Konfigurasi Bab &rarr;</button>
        </div>
    </form>

<?php elseif ($step == 2): ?>
    <h3 class="text-xl font-bold text-gray-800 mb-4">Langkah 2: Nama Bab & Jumlah TP</h3>
    <form method="POST" action="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=3" class="space-y-6">
        <input type="hidden" name="action_type" value="save_step_2">
        <?php for ($i = 0; $i < $config['chapter_count']; $i++): ?>
            <div class="p-4 bg-gray-50 rounded-lg shadow-inner border border-gray-200">
                <h4 class="font-bold text-md text-gray-800 mb-3">Bab ke-<?php echo $i + 1; ?></h4>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="md:col-span-1">
                        <label for="chapter_name_<?php echo $i; ?>" class="block text-sm font-medium text-gray-700">Nama Singkat (Contoh: Bab I)</label>
                        <input type="text" id="chapter_name_<?php echo $i; ?>" name="chapter_name_<?php echo $i; ?>" required 
                            value="<?php echo $config['chapters'][$i]['name'] ?? "Bab " . ($i + 1); ?>" 
                            class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                    </div>
                    <div class="md:col-span-1">
                        <label for="chapter_topic_<?php echo $i; ?>" class="block text-sm font-medium text-gray-700">Deskripsi/Topik (Contoh: Energi)</label>
                        <input type="text" id="chapter_topic_<?php echo $i; ?>" name="chapter_topic_<?php echo $i; ?>" required 
                            value="<?php echo $config['chapters'][$i]['topic'] ?? "Topik Bab " . ($i + 1); ?>" 
                            class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                    </div>
                    <div class="md:col-span-1">
                        <label for="tp_count_<?php echo $i; ?>" class="block text-sm font-medium text-gray-700">Jumlah Tujuan Pembelajaran (TP)</label>
                        <input type="number" id="tp_count_<?php echo $i; ?>" name="tp_count_<?php echo $i; ?>" min="1" required 
                            value="<?php echo $config['chapters'][$i]['tp_count'] ?? 3; ?>" 
                            class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                        <p class="text-xs text-gray-500 mt-1">Total TP dalam bab ini.</p>
                    </div>
                </div>
            </div>
        <?php endfor; ?>
        <div class="flex justify-between">
            <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=1" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-6 rounded-lg">&larr; Kembali</a>
            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-6 rounded-lg shadow-md transition">Lanjut ke Deskripsi TP &rarr;</button>
        </div>
    </form>

<?php elseif ($step == 3): ?>
    <h3 class="text-xl font-bold text-gray-800 mb-4">Langkah 3: Deskripsi Tujuan Pembelajaran (TP)</h3>
    <p class="text-sm text-gray-600 mb-6">Tuliskan deskripsi singkat untuk setiap Tujuan Pembelajaran (TP) di bawah ini.</p>
    <form method="POST" action="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>" class="space-y-6">
        <input type="hidden" name="action_type" value="final_save">
        <div class="space-y-6 p-4 bg-purple-50 rounded-xl border-l-4 border-purple-500">
            <?php foreach($config['chapters'] as $i => $chapter): ?>
                <div class="p-4 bg-white rounded-lg shadow mb-4">
                    <h4 class="font-bold text-md text-purple-700 mb-3">TP untuk <?php echo htmlspecialchars($chapter['name']); ?>: <?php echo htmlspecialchars($chapter['topic']); ?></h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                        <?php for ($j = 0; $j < $chapter['tp_count']; $j++): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">TP <?php echo ($i+1) . "." . ($j+1); ?></label>
                                <input type="text" name="tp_topic_<?php echo "{$i}_{$j}"; ?>" 
                                    value="<?php echo $config['chapters'][$i]['tps'][$j]['topic'] ?? "Deskripsi TP " . ($i+1) . "." . ($j+1); ?>" 
                                    required class="mt-1 p-2 block w-full border-gray-300 rounded-md">
                            </div>
                        <?php endfor; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="flex justify-between">
            <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>&step=2" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-6 rounded-lg">&larr; Kembali</a>
            <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-bold py-3 px-6 rounded-lg shadow-md transition">Simpan Konfigurasi Final (SAS/STS)</button>
        </div>
    </form>
<?php endif; ?>

</div>

<?php include 'footer.php'; ?>