<?php include 'header.php'; ?>

<div class="flex justify-between items-center mb-6">
    <h2 class="text-2xl font-bold text-gray-800">Daftar Sekolah</h2>
    <?php if (!isset($_SESSION['is_viewer']) || !$_SESSION['is_viewer']): ?>
        <div class="flex gap-4">
            <a href="index.php?action=viewer_login_form" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded-lg transition">👁️ Masuk ke Mode Viewer</a>
            <a href="index.php?action=add_school_form" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">+ Tambah Sekolah</a>
        </div>
    <?php endif; ?>
</div>

<?php if (empty($schools)): ?>
    <div class='text-center p-10 bg-yellow-50 border border-yellow-200 rounded-lg'>
        <p class='text-gray-600'>Belum ada data sekolah yang tersimpan.</p>
        <?php if (!isset($_SESSION['is_viewer']) || !$_SESSION['is_viewer']): ?>
            <a href="index.php?action=add_school_form" class="mt-4 inline-block bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">Tambahkan Sekolah Pertama</a>
        <?php endif; ?>
    </div>
<?php else: ?>
    <div class="overflow-x-auto shadow rounded-lg">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Sekolah</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php foreach($schools as $school): // Menggunakan foreach karena index.php sudah fetchAll() ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($school['name']); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                        <a href="index.php?action=view_class&school_id=<?php echo $school['id']; ?>" class="text-indigo-600 hover:text-indigo-900 font-semibold">Lihat Kelas</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php include 'footer.php'; ?>