<?php include 'header.php'; ?>

<div class="mb-6">
    <a href="index.php" class="text-blue-600 hover:text-blue-800 font-semibold">&larr; Kembali ke Daftar Sekolah</a>
    <h2 class="text-2xl font-bold text-gray-800 mt-2">Kelas di <?php echo htmlspecialchars($school['name']); ?></h2>
</div>

<div class="flex justify-between items-center mb-6">
    <h3 class="text-xl font-semibold">Daftar Kelas</h3>
    <?php if (!isset($_SESSION['is_viewer']) || !$_SESSION['is_viewer']): ?>
        <a href="index.php?action=add_class_form&school_id=<?php echo $school_id; ?>" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">+ Tambah Kelas</a>
    <?php endif; ?>
</div>

<?php if (empty($result_classes)): ?>
    <div class='text-center p-10 bg-yellow-50 border border-yellow-200 rounded-lg'>
        <p class='text-gray-600'>Belum ada kelas yang terdaftar di sekolah ini.</p>
        <?php if (!isset($_SESSION['is_viewer']) || !$_SESSION['is_viewer']): ?>
            <a href="index.php?action=add_class_form&school_id=<?php echo $school_id; ?>" class="mt-4 inline-block bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">Tambahkan Kelas Pertama</a>
        <?php endif; ?>
    </div>
<?php else: ?>
    <div class="overflow-x-auto shadow rounded-lg mb-8">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Kelas</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">KKM</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php foreach($result_classes as $class): // Menggunakan foreach karena index.php sudah fetchAll() ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($class['name']); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700"><?php echo $class['kktp']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                        <?php if (!isset($_SESSION['is_viewer']) || !$_SESSION['is_viewer']): ?>
                            <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class['id']; ?>" class="text-indigo-600 hover:text-indigo-900 mr-4 font-semibold">Dashboard Admin</a>
                        <?php endif; ?>
                        <a href="index.php?action=view_class_scores&class_id=<?php echo $class['id']; ?>" class="text-green-600 hover:text-green-900 font-semibold">Lihat Nilai</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php include 'footer.php'; ?>