<?php include 'header.php'; ?>

<div class="mb-6 text-sm">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">Daftar Sekolah</a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class&school_id=<?php echo $class['school_id']; ?>" class="text-blue-600 hover:text-blue-800">Kelas di <?php echo htmlspecialchars($school['name']); ?></a>
    <span class="text-gray-400 mx-2">/</span>
    <span class="text-gray-600 font-semibold">Dashboard</span>
</div>

<div class="mb-6 border-b pb-4">
    <h2 class="text-2xl font-bold text-gray-800">Dashboard Kelas: <?php echo htmlspecialchars($class['name']); ?></h2>
    <p class="text-gray-600">KKM (KKTP) untuk kelas ini adalah: <strong><?php echo $class['kktp']; ?></strong></p>
</div>

<div class="mb-6">
    <?php if ($assessment): ?>
        <div class="p-4 bg-blue-50 rounded-xl border-l-4 border-blue-400 text-blue-800 shadow-sm">
            <p class="font-semibold">Asesmen Aktif:</p> 
            <p class="text-xl font-bold">
                <?php echo htmlspecialchars($assessment['type'] ?? 'General Assessment'); ?> 
            </p>
            <p class="text-sm text-gray-600 mt-1">PG Max: <?php echo $assessment['pg_max']; ?>, Isian Max: <?php echo $assessment['isian_max']; ?>, Esai Max: <?php echo $assessment['essay_max']; ?></p>
            <div class="mt-3 flex gap-4">
                <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>" class="text-sm bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-1 px-3 rounded-lg transition">✏️ Edit Konfigurasi</a>
                <a href="index.php?action=view_class_scores&class_id=<?php echo $class_id; ?>" class="text-sm bg-green-600 hover:bg-green-700 text-white font-bold py-1 px-3 rounded-lg transition">Lihat Rekap Nilai</a>
            </div>
        </div>
    <?php else: ?>
        <div class="p-4 bg-red-100 rounded-xl border-l-4 border-red-500 text-red-800 shadow-sm">
            <p class="font-semibold">Status Asesmen:</p>
            <p class="text-xl font-bold mb-3">BELUM DIKONFIGURASI</p>
            <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>" class="text-sm bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded-lg transition">⚙️ Mulai Konfigurasi Sekarang</a>
        </div>
    <?php endif; ?>
</div>

<div class="bg-gray-50 p-6 rounded-xl mb-8 shadow-sm">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-xl font-semibold text-gray-700 flex items-center">
            <svg class="inline-block w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20"><path d="M13 6a3 3 0 11-6 0 3 3 0 016 0zM18 8a2 2 0 11-4 0 2 2 0 014 0zM14 15a4 4 0 00-8 0v3h8v-3zM6 8a2 2 0 11-4 0 2 2 0 014 0zM16 18H4v-3a6 6 0 0112 0v3z"></path></svg>
            Daftar Siswa
        </h3>
        <a href="index.php?action=add_student_form&class_id=<?php echo $class_id; ?>" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">+ Tambah Siswa</a>
    </div>

    <?php if (empty($students)): ?>
        <p class="text-gray-500 text-center py-4">Belum ada siswa di kelas ini.</p>
    <?php else: ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">NIS</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Siswa</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php foreach ($students as $student): // Menggunakan foreach ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($student['student_number']); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($student['name']); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <?php if ($assessment): ?>
                                <a href="index.php?action=grade_student&student_id=<?php echo $student['id']; ?>" class="text-indigo-600 hover:text-indigo-900 ml-4 font-semibold">Input/Edit Nilai</a>
                                <a href="index.php?action=view_class_scores&class_id=<?php echo $class_id; ?>&student_id=<?php echo $student['id']; ?>" class="text-gray-600 hover:text-gray-900 ml-4">Lihat Detail Nilai</a>
                            <?php else: ?>
                                <span class="text-red-500 text-xs">Asesmen belum siap.</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>


<?php include 'footer.php'; ?>