<?php
session_start();

// Pengecekan sesi untuk mencegah akses langsung
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Misalkan kita juga menyimpan nama pengguna di sesi
 $user_display_name = isset($_SESSION['user_name']) ? htmlspecialchars($_SESSION['user_name']) : htmlspecialchars($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Sekolah</title>
    
    <!-- Font Inter -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome untuk Ikon -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- ============================= -->
    <!-- === CSS STYLES (EMBEDDED) === -->
    <!-- ============================= -->
    <style>
        /* ------------------- */
        /* --- VARIABEL CSS --- */
        /* ------------------- */
        :root {
            --primary-color: #4e73df;
            --secondary-color: #858796;
            --success-color: #1cc88a;
            --info-color: #36b9cc;
            --warning-color: #f6c23e;
            --danger-color: #e74a3b;
            --light-color: #f8f9fc;
            --dark-color: #5a5c69;
            --white-color: #ffffff;
            --sidebar-width: 250px;
            --font-family: 'Inter', sans-serif;
        }

        /* ------------------- */
        /* --- RESET & BASE --- */
        /* ------------------- */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            height: 100%;
            font-family: var(--font-family);
            background-color: var(--light-color);
            color: var(--dark-color);
        }

        /* ------------------- */
        /* --- KOMPONEN UTAMA --- */
        /* ------------------- */
        .dashboard-container {
            display: flex;
            height: 100vh;
            overflow: hidden;
        }

        /* --- Sidebar --- */
        .sidebar {
            width: var(--sidebar-width);
            min-width: var(--sidebar-width);
            background: linear-gradient(180deg, var(--primary-color) 10%, #2e59d9 100%);
            color: var(--white-color);
            transition: margin-left 0.3s ease-in-out;
            position: relative;
            z-index: 30;
        }

        .sidebar-header {
            padding: 1.5rem;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar-header h3 {
            font-size: 1.5rem;
            font-weight: 700;
        }

        .sidebar-header i {
            margin-right: 0.5rem;
        }

        .sidebar-nav {
            list-style: none;
            padding: 0;
        }

        .sidebar-nav li a {
            display: flex;
            align-items: center;
            padding: 1rem 1.5rem;
            color: var(--white-color);
            text-decoration: none;
            transition: background-color 0.2s;
        }

        .sidebar-nav li a:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .sidebar-nav li.active a {
            background-color: rgba(255, 255, 255, 0.2);
            font-weight: 600;
        }

        .sidebar-nav li a i {
            width: 24px;
            text-align: center;
            margin-right: 0.75rem;
        }

        /* --- Main Content Area --- */
        .main-content {
            flex: 1;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        /* --- Navbar --- */
        .navbar {
            background-color: var(--white-color);
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            padding: 0 1rem;
            z-index: 20;
        }

        .navbar-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 65px;
        }

        .sidebar-toggle-btn {
            background: none;
            border: none;
            font-size: 1.2rem;
            color: var(--dark-color);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.25rem;
            transition: color 0.2s;
        }

        .sidebar-toggle-btn:hover {
            color: var(--primary-color);
        }

        .user-area {
            display: flex;
            align-items: center;
        }

        .user-dropdown-btn {
            display: flex;
            align-items: center;
            background: none;
            border: none;
            color: var(--dark-color);
            font-weight: 500;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.25rem;
            transition: background-color 0.2s;
        }

        .user-dropdown-btn:hover {
            background-color: var(--light-color);
        }

        .user-dropdown-btn i.fa-user-circle {
            font-size: 1.5rem;
            margin-right: 0.5rem;
        }

        .user-dropdown-btn i.fa-chevron-down {
            font-size: 0.7rem;
            margin-left: 0.5rem;
        }

        .dropdown-menu {
            position: absolute;
            right: 1rem;
            top: 100%;
            margin-top: 0.5rem;
            background-color: var(--white-color);
            border-radius: 0.5rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            min-width: 10rem;
            z-index: 50;
        }

        .dropdown-menu a {
            display: block;
            padding: 0.75rem 1rem;
            color: var(--dark-color);
            text-decoration: none;
            font-size: 0.9rem;
            transition: background-color 0.2s;
        }

        .dropdown-menu a:hover {
            background-color: var(--light-color);
        }

        .dropdown-menu hr {
            border: none;
            border-top: 1px solid #e3e6f0;
            margin: 0.25rem 0;
        }

        /* --- Content Area --- */
        .content-area {
            flex: 1;
            overflow-y: auto;
            padding: 2rem;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .page-header {
            text-align: center;
            margin-bottom: 3rem;
        }

        .page-header h1 {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--dark-color);
        }

        .page-header p {
            font-size: 1.125rem;
            color: var(--secondary-color);
            margin-top: 0.5rem;
        }

        /* --- Menu Grid --- */
        .menu-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1.5rem;
        }

        /* --- Menu Card --- */
        .menu-card {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background-color: var(--white-color);
            border: 1px solid #e3e6f0;
            border-radius: 0.75rem;
            padding: 1.5rem;
            height: 140px;
            text-align: center;
            text-decoration: none;
            color: var(--dark-color);
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            transition: all 0.3s ease-in-out;
        }

        .menu-card:hover {
            transform: translateY(-5px) scale(1.03);
            box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.175);
            background-color: #f0f4ff; /* Light indigo background */
        }

        .menu-card .menu-title {
            font-size: 1.125rem;
            font-weight: 600;
            margin-top: 0.75rem;
        }

        .menu-card .menu-desc {
            font-size: 0.875rem;
            color: var(--secondary-color);
            margin-top: 0.25rem;
        }

        /* --- Icon Colors --- */
        .menu-card i { font-size: 2rem; }
        .icon-indigo { color: #667eea; }
        .icon-green { color: #48bb78; }
        .icon-yellow { color: #f6ad55; }
        .icon-sky { color: #4fc3f7; }
        .icon-blue { color: #4299e1; }
        .icon-purple { color: #9f7aea; }
        .icon-orange { color: #ed8936; }
        .icon-gray { color: #718096; }

        /* --- Footer --- */
        .page-footer {
            text-align: center;
            margin-top: 4rem;
            padding-top: 2rem;
            border-top: 1px solid #e3e6f0;
            color: var(--secondary-color);
            font-size: 0.875rem;
        }

        /* ------------------- */
        /* --- RESPONSIVITAS --- */
        /* ------------------- */
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                left: 0;
                top: 0;
                height: 100vh;
                margin-left: calc(-1 * var(--sidebar-width));
            }
            
            .sidebar.active {
                margin-left: 0;
            }

            .content-area {
                padding: 1rem;
            }

            .page-header h1 {
                font-size: 2rem;
            }

            .menu-grid {
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
                gap: 1rem;
            }
            
            .menu-card {
                height: 120px;
                padding: 1rem;
            }
        }

        /* ------------------- */
        /* --- UTILITAS --- */
        /* ------------------- */
        .hidden {
            display: none;
        }
    </style>
</head>
<body>

    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar">
            <div class="sidebar-header">
                <h3><i class="fas fa-graduation-cap"></i> MySchool</h3>
            </div>
            <ul class="sidebar-nav">
                <li class="active"><a href="#"><i class="fas fa-home"></i> Dashboard</a></li>
                <li><a href="#"><i class="fas fa-user"></i> Profil</a></li>
                <li><a href="#"><i class="fas fa-cog"></i> Pengaturan</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </aside>

        <!-- Konten Utama -->
        <div class="main-content">
            <!-- Navbar Atas -->
            <nav class="navbar">
                <div class="navbar-content">
                    <button type="button" id="sidebarCollapse" class="sidebar-toggle-btn">
                        <i class="fas fa-bars"></i>
                    </button>
                    
                    <div class="user-area">
                        <!-- Dropdown User -->
                        <div class="user-dropdown">
                            <button id="userDropdownBtn" class="user-dropdown-btn">
                                <i class="fas fa-user-circle"></i>
                                <span><?php echo $user_display_name; ?></span>
                                <i class="fas fa-chevron-down"></i>
                            </button>
                            <div id="dropdownMenu" class="dropdown-menu hidden">
                                <a href="#">Profil Saya</a>
                                <a href="#">Pengaturan</a>
                                <hr>
                                <a href="logout.php">Keluar</a>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Area Konten Dashboard (Menu Sekolah) -->
            <main class="content-area">
                <div class="container">
                    
                    <header class="page-header">
                        <h1>Dashboard Informasi Sekolah</h1>
                        <p>Menu cepat untuk Siswa, Guru, dan Orang Tua.</p>
                    </header>

                    <!-- Grid Menu -->
                    <div class="menu-grid">
                        <!-- Menu Item 1: Absensi -->
                        <a href="absensi/" class="menu-card">
                            <i class="fas fa-check-circle icon-indigo"></i>
                            <span class="menu-title">Absensi</span>
                            <span class="menu-desc">Status Kehadiran.</span>
                        </a>

                        <!-- Menu Item 2: Nilai Rapot -->
                        <a href="nilai/" class="menu-card">
                            <i class="fas fa-chart-bar icon-green"></i>
                            <span class="menu-title">Nilai Rapot</span>
                            <span class="menu-desc">Cek hasil belajar.</span>
                        </a>
                        
                        <!-- Menu Item 3: Jadwal Pelajaran -->
                        <a href="jadwal" class="menu-card">
                            <i class="fas fa-calendar-alt icon-yellow"></i>
                            <span class="menu-title">Jadwal</span>
                            <span class="menu-desc">Jam & Mata Pelajaran.</span>
                        </a>

                        <!-- Menu Item 4: Materi Belajar -->
                        <a href="#materi" class="menu-card">
                            <i class="fas fa-book-open icon-sky"></i>
                            <span class="menu-title">Materi</span>
                            <span class="menu-desc">Unduh modul.</span>
                        </a>
                        
                        <!-- Menu Item 5: Tugas & PR -->
                        <a href="#tugas" class="menu-card">
                            <i class="fas fa-tasks icon-blue"></i>
                            <span class="menu-title">Tugas & PR</span>
                            <span class="menu-desc">Kumpulkan pekerjaan.</span>
                        </a>
                        
                        <!-- Menu Item 6: Pengumuman -->
                        <a href="#pengumuman" class="menu-card">
                            <i class="fas fa-bullhorn icon-purple"></i>
                            <span class="menu-title">Pengumuman</span>
                            <span class="menu-desc">Info terbaru sekolah.</span>
                        </a>

                        <!-- Menu Item 7: Profil Siswa -->
                        <a href="#profil" class="menu-card">
                            <i class="fas fa-user icon-orange"></i>
                            <span class="menu-title">Profil Siswa</span>
                            <span class="menu-desc">Data diri & kontak.</span>
                        </a>

                        <!-- Menu Item 8: Pusat Bantuan -->
                        <a href="#bantuan" class="menu-card">
                            <i class="fas fa-question-circle icon-gray"></i>
                            <span class="menu-title">Pusat Bantuan</span>
                            <span class="menu-desc">Panduan & FAQ.</span>
                        </a>
                    </div>

                    <footer class="page-footer">
                        © 2024 Aplikasi Dashboard Sekolah. Semua Hak Cipta Dilindungi.
                    </footer>
                </div>
            </main>
        </div>
    </div>

    <!-- ================================= -->
    <!-- === JAVASCRIPT LOGIC (EMBEDDED) === -->
    <!-- ================================= -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log("Script loaded successfully!"); // Log untuk memastikan script berjalan

            const sidebarCollapse = document.getElementById('sidebarCollapse');
            const sidebar = document.getElementById('sidebar');
            const userDropdownBtn = document.getElementById('userDropdownBtn');
            const dropdownMenu = document.getElementById('dropdownMenu');

            // --- Toggle Sidebar ---
            if (sidebarCollapse && sidebar) {
                sidebarCollapse.addEventListener('click', function() {
                    console.log('Sidebar toggle button clicked!'); // Log untuk memastikan event terpicu
                    sidebar.classList.toggle('active');
                });
            } else {
                console.error('Sidebar toggle button or sidebar element not found!');
            }

            // --- Toggle Dropdown User ---
            if (userDropdownBtn && dropdownMenu) {
                userDropdownBtn.addEventListener('click', function(e) {
                    e.preventDefault(); // Mencegah aksi default tombol
                    dropdownMenu.classList.toggle('hidden');
                });

                // Tutup dropdown jika klik di luar dropdown
                window.addEventListener('click', function(e) {
                    if (!userDropdownBtn.contains(e.target) && !dropdownMenu.contains(e.target)) {
                        dropdownMenu.classList.add('hidden');
                    }
                });
            }

            // --- Interaksi untuk Menu Grid Utama SAJA ---
            // Event ini hanya akan berlaku untuk link yang memiliki class 'menu-card'
            // dan TIDAK akan memengaruhi link logout di sidebar atau dropdown.
            // const menuCards = document.querySelectorAll('.menu-card');
            menuCards.forEach(card => {
                card.addEventListener('click', function(e) {
                    // Mencegah navigasi agar bisa menampilkan alert (untuk demo)
                    // Hapus baris ini di aplikasi nyata agar link berfungsi normal
                    e.preventDefault(); 
                    
                    const title = this.querySelector('.menu-title').textContent;
                    alert(`Anda mengklik menu: ${title}\nDalam aplikasi nyata, Anda akan diarahkan ke halaman ${title}.`);
                });
            });

        });
    </script>
</body>
</html>